<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Access extends MY_Controller{
	public function index(){
		$this->load->model("menu_model");
		
		$data['menu'] = $this->menu_model->get_data(array(
			'condition' => "<T>.AVAILABLE = '1'",
			'sort' => "WEB_MENU.SEQN",
		));
		$data['id'] = $this->input->get('id');
		
		$this->load->view($this->router->fetch_class()."/".$this->router->fetch_method(), $data);
	}
	
	public function edit(){
		$this->load->model("menu_model");
		$this->load->model("group_model");
		$post = $this->input->post();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		if($this->input->post('PKKEY') != ""){
			$data = array();
			
			$menu_array = $post['PKKEY'] != "0"? $this->menu_model->get_data(array(
				'condition' => "<T>.<PK> = '".$post['PKKEY']."'",
			)):array();
			if(count($menu_array) > 0){
				$data['menu'] = $menu_array[0];
			}
			$data['access_array'] = $this->fm->index_array($this->access_model->get_data(array(
				'condition' => "<T>.MENU = '".$post['PKKEY']."'",
			)), "USER_GROUP");
			$data['all_group'] = $this->group_model->get_data(array(
				'sort' => "WEB_GROUP.SEQN",
			));
			
			$this->load->view($this->router->fetch_class()."/edit", $data);
		}
	}
	
	public function update(){
		$this->load->model("access_model");
		$this->load->model("menu_model");
		$post = $this->input->post();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
//		print_r($post);
//		return;
		
		$parent_id = "";
		
		if(isset($post['MENU'])){
			$access_array = $this->fm->index_array($this->access_model->get_data(array(
				'condition' => "<T>.MENU = '".$post['MENU']."'",
			)), "USER_GROUP");
			
			if(isset($post['USER_GROUP'])){
				foreach($post['USER_GROUP'] as $v){
					if(! isset($access_array[$v])){
						unset($data);
						$data['MENU'] = $post['MENU'];
						$data['USER_GROUP'] = $v;
						
						$this->access_model->save($data);
					}
					else{
						unset($access_array[$v]);
					}
				}
			}
			
			if(count($access_array) > 0){
				$condition = $this->fm->build_condition($access_array, "USER_GROUP", "USER_GROUP");
				$condition = $this->fm->append($condition, "MENU = '".$post['MENU']."'");
				$this->access_model->sql_delete_condition($condition);
			}
			
			$menu_array = $this->menu_model->get_data(array(
				'condition' => "<T>.<PK> = ".$post['MENU'],
			));
			$parent_id = $menu_array[0]->PARENT_ID;
			
			if($parent_id == 0){
				$parent_id = $post['MENU'];
			}
			else{
				$temp = $this->menu_model->get_data(array(
					'condition' => "<T>.<PK> = ".$parent_id,
				));
				
				if($temp[0]->PARENT_ID == 0){
					$parent_id = $parent_id;
				}
				else{
					$parent_id = $temp[0]->PARENT_ID;
				}
			}
		}
		
		$this->session->set_flashdata('success', "Update Successful!");
		
		redirect(base_url($this->router->fetch_class()."?id=".$parent_id));
	}
	
	public function toggle_up($menu_id){
		$this->load->model("menu_model");
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		$parent_id = $this->menu_model->toggle($menu_id, "up");
		
//		$this->session->set_flashdata('success', "Update Successful!");
		
		redirect(base_url($this->router->fetch_class()."?id=".$parent_id));
	}
	
	public function toggle_down($menu_id){
		$this->load->model("menu_model");
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		$parent_id = $this->menu_model->toggle($menu_id, "down");
		
//		$this->session->set_flashdata('success', "Update Successful!");
		
		redirect(base_url($this->router->fetch_class()."?id=".$parent_id));
	}
}
