<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class API extends MY_Controller{
	public function index(){
		show_404();
	}
	
	public function force_logout(){
		$this->load->model("login_model");
	
		if($this->record_login && $this->session->userdata('login_id') != ""){
			$login_data['DATE_LOGOUT'] = date("Y-m-d H:i:s");
			
			$this->login_model->sql_update($login_data, $this->session->userdata('login_id'));
		}
		
		$this->session->sess_destroy();
	}
	
	public function check_force_logout(){
		$user = $this->fm->get_current_user();

		if(!empty($user)){
			if($user->FORCE_LOGOUT == 1){
				echo 1;
			}
		}
	}
	
	public function check_inactive(){
		$user = $this->fm->get_current_user();

		if(!empty($user)){
			if($user->ACTIVE != 1){
				echo 1;
			}
		}
	}
	
	public function get_resource(){
		$this->load->model("group_model");
		$this->load->model("user_model");
		$this->load->model("debtor_model");

		$get = $this->input->get();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		if($this->input->get('t') != ""){
			$query['created'] = date('Y-m-d H:i:s');
			
			foreach($get['t'] as $x=>$target){
				$data = array();
				$condition = isset($get['c'][$x])? urldecode($get['c'][$x]):"";
				$sort = isset($get['s'][$x])? $get['s'][$x]:"";
				
				switch($target){
					case "GROUP":
						$data_array = $this->group_model->get_data(array(
							'condition' => $condition,
							'sort' => $sort,
						));
						foreach($data_array as $v){
							unset($sub_data);
							$sub_data['PKKEY'] = $v->PKKEY;
							$sub_data['NAME'] = $v->NAME;
							
							array_push($data, $sub_data);
						}
						$query[$target] = $data;
						break;

					case "WEB_USER":
						$data_array = $this->user_model->get_data(array(
							'condition' => $condition,
							'sort' => $sort,
						));
						foreach($data_array as $v){
							unset($sub_data);
							$sub_data['PKKEY'] = $v->PKKEY;
							$sub_data['NAME'] = "";
							if($v->CODE != "") $sub_data['NAME'] .= "[".trim($v->CODE)."] ";
							$sub_data['NAME'] .= $v->NAME;
							
							array_push($data, $sub_data);
						}
						$query[$target] = $data;
						break;
					case "DEBTOR":
						$data_array = $this->debtor_model->get_data(array(
							'condition' => $condition,
							'sort' => $sort,
						));
						foreach($data_array as $v){
							unset($sub_data);
							$sub_data['CODE'] = $v->CODE;
							$sub_data['NAME'] = "";
							if($v->CODE != "") $sub_data['NAME'] .= "[".trim($v->CODE)."] ";
							$sub_data['NAME'] .= $v->NAME;
							
							array_push($data, $sub_data);
						}
						$query[$target] = $data;
						break;

				}
			}
			
			echo json_encode($query);
		}
	}
	
	public function call_exe(){
		$this->load->model("menu_exe_model");
		$this->load->model("user_model");
		$get = $this->input->get();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		$json = array();
		
		if($this->input->get('MENU') != "" && $this->input->get('USER_ID') != ""){
			$user_array = $this->user_model->get_data(array(
				'condition' => "<T>.<PK> = '".$get['USER_ID']."'",
				'' => "",
			));
			
			unset($data);
			$data['MENU'] = $get['MENU'];
			if(count($user_array) > 0) $data['USER_ID'] = strtoupper($user_array[0]->CODE);
			if(isset($_SERVER['REMOTE_ADDR'])) $data['IP'] = $_SERVER['REMOTE_ADDR'];
			$data['DATE_START'] = date("Y-m-d H:i:s");
			
			if(isset($data['USER_ID']) || isset($data['IP'])){
				$condition = "";
				$condition = $this->fm->append($condition, "<T>.MENU = '".$data['MENU']."'");
				if(isset($data['USER_ID'])) $condition = $this->fm->append($condition, "<T>.USER_ID = '".$this->fm->str_esc($data['USER_ID'], 1)."'");
				if(isset($data['IP'])) $condition = $this->fm->append($condition, "<T>.IP = '".$data['IP']."'");
				$condition = $this->fm->append($condition, "<T>.DATE_END IS NULL");
				$existing_array = $this->menu_exe_model->get_data(array(
					'condition' => $condition,
					'' => "",
				));
			}
			else{
				$existing_array = array();
			}
			
			if(count($existing_array) == 0){
				$return = $this->menu_exe_model->save($data);
				if($return['error'] == "" && $return['pk'] != -1){
					$json['PK'] = $return['pk'];
				}
			}
		}
		
		echo json_encode($json);
	}
	
	public function call_exe_is_complete(){
		$this->load->model("menu_exe_model");
		$get = $this->input->get();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		$json = array(
			'COMPLETE' => FALSE,
		);
		
		if($this->input->get('PK') != ""){
			$data_array = $this->menu_exe_model->get_data(array(
				'condition' => "<T>.<PK> = '".$get['PK']."' AND <T>.DATE_END IS NOT NULL",
				'' => "",
			));
			
			if(count($data_array) > 0) $json['COMPLETE'] = TRUE;
		}
		
		echo json_encode($json);
	}

	public function get_attach($pkkey=""){
		$this->load->helper("file");
		$this->load->model("item_attachment_model");
		$get = $this->input->get();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		$attach_array = $pkkey != ""? $this->item_attachment_model->get_data(array(
			'condition' => "<T>.PKKEY = '".$pkkey."'",
			'additional_select' => "OCTET_LENGTH(<T>.CONTENT) AS CONTENT_SIZE",
			//'sort' => "<T>.FILENAME",
		)):array();
		
		if(count($attach_array) > 0){
			$attach = $attach_array[0];
			
			if($this->input->get('download') == "1"){
				header("Pragma: public");
				header("Expires: 0");
				header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
				header("Cache-Control: private", false); // required for certain browsers 
				header("Content-Type: text/plain");

				header("Content-Disposition: attachment; filename=".$attach->FILENAME. ";");
				header("Content-Transfer-Encoding: binary");
				header("Content-Length: ".$attach->CONTENT_SIZE);
				
				echo $attach->CONTENT;
			}else{
				header("Content-type: ".get_mime_by_extension($attach->FILENAME));
				echo $attach->CONTENT;
			}
			
			return;
		}
		
		show_404();
	}
	
	public function delete_attach($pkkey=""){
		$this->load->model("item_attachment_model");
		$get = $this->input->get();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		if($pkkey != "") $this->item_attachment_model->remove($pkkey);
		
		echo "1";
	}
}