<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Gold extends MY_Controller{
	public function index(){
		$this->load->view($this->router->fetch_class()."/index");
	}
	
	public function edit($id=""){
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		$data['id'] = $id != ""? $id:0;
		
		$this->load->view($this->router->fetch_class()."/edit", $data);
	}
	
	public function load_edit(){
		$this->load->model("gold_model");
		$post = $this->input->post();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		$data = array();
		
		//Access---
		$access_array = $this->fm->get_access(array(27, 28, 29));
		$data['can_create'] = isset($access_array[27]);
		$data['can_edit'] = isset($access_array[28]);
		$data['can_delete'] = isset($access_array[29]);
		//---------
		
		if($this->input->post('CODE') != "0"){
			$data_array = $this->gold_model->get_data(array(
				'condition' => "<T>.<PK> = '".$this->fm->str_esc($post['CODE'], 1)."'",
				'additional_select' => "",
				'' => "",
			));
			
			if(count($data_array) > 0){
				$data['data'] = $data_array[0];
			}
		}

		$this->load->model("taxcode_model");
        $data['all_taxcode'] = $this->taxcode_model->get_data( array(
            'sort' => "<T>.CODE",
            '' => "",
        ));

        $this->load->model("category_model");
        $data['all_category'] = $this->category_model->get_data( array(
            'sort' => "<T>.CODE",
            '' => "",
        ));

        $this->load->model("item_grp_model");
        $data['all_item_grp'] = $this->item_grp_model->get_data( array(
            'sort' => "<T>.CODE",
            '' => "",
        ));
		
		if(($data['can_create'] && $this->input->post('CODE') == "0") || (isset($data['data']))){
			$this->load->view($this->router->fetch_class()."/load_edit", $data);
			return;
		}
		
		header("HTTP/1.1 500 Internal Server Error");
		header("Content-Type: application/json; charset=UTF-8");
		return;
	}
	
	public function update(){
		$this->load->model("gold_model");
		$post = $this->input->post();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		// print_r($post);
		// return;
		
		$return = $this->gold_model->save($post);
		
		if($return['error'] == ""){
			$action = ! isset($post['CODE'])? "Create":"Update";
			$this->session->set_flashdata('success', $action." Successful!");
		}
		else{
			$this->session->set_flashdata('error', $return['error']);
		}
		
		if(isset($post['CODE'])){
			$redirect_params = "";
			$redirect_params .= "/edit/".$post['CODE'];
        	redirect(base_url($this->router->fetch_class().$redirect_params));
		}else{
			redirect(base_url($this->router->fetch_class()."?".$this->session->flashdata($this->router->fetch_class().'_page_filter')));
		}
	}
	
	public function delete(){
		$this->load->model("gold_model");
		$post = $this->input->post();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		$pk = $this->gold_model->sql_get_pk();
		if(isset($post[$pk]) && $this->gold_model->remove($post[$pk])){
			$this->session->set_flashdata('success', "Delete Successful!");
		}
		else{
			$this->session->set_flashdata('error', "Delete Failed!");
		}
		
		redirect(base_url($this->router->fetch_class()."?".$this->session->flashdata($this->router->fetch_class().'_page_filter')));
	}
	
	public function check_unique(){
		$this->load->model("gold_model");
		$post = $this->input->post();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		if($this->input->post('unique') != ""){
			$condition = "<T>.CODE = '".$this->fm->str_esc($post['unique'], 1)."'";
			if(isset($post['pk'])) $condition .= " AND <T>.<PK> != '".$post['pk']."'";
			$data_array = $this->gold_model->get_data(array(
				'condition' => $condition,
			));
			
			if(count($data_array) == 0){
				echo "1";
			}
		}
	}
	
	public function load_data(){
		$this->load->model("gold_model");
		$post = $this->input->post();
		$this->load->model("company_profile_model");
		$data['print'] = $this->input->post('print');
		
//		print_r($post);
		
		//Config---
		$config['page'] = (int)$this->input->post('PAGE') > 0? (int)$post['PAGE']:1;
		$config['cur_page'] = $config['page'];
		$config['page'] -= 1;
		$config['per_page'] = (int)$this->input->post('PP') > 0? (int)$post['PP']:$this->per_page_array[0];
		$config['previous_btn'] = TRUE;
		$config['next_btn'] = TRUE;
		$config['first_btn'] = TRUE;
		$config['last_btn'] = TRUE;
		//---------
		
		$condition = "";
			
		//Search---
		if($this->input->post('CODE') != ""){
			$condition = $this->fm->append($condition, "<T>.CODE LIKE '%".$this->fm->str_esc($post['CODE'], 1)."%'");
		}
		
		//---------
		
		$data['header_array'] = array(
			array(
				'description' => "#",
				'style' => "width: 1%; white-space: nowrap; text-align: center;",
				'sort' => "",
			),
			array(
				'description' => "Gold Code",
				'style' => "width: 1%; white-space: nowrap; text-align: center;",
				'sort' => "<T>.CODE",
			),
			array(
				'description' => "Name",
				'style' => "width: 1%; white-space: nowrap; text-align: center;",
				'sort' => "<T>.NAME",
			),
			array(
				'description' => "Description",
				'style' => "width: 1%; white-space: nowrap; text-align: center;",
				'sort' => "<T>.DESCRIPT",
			),
			array(
				'description' => "Category",
				'style' => "width: 1%; white-space: nowrap; text-align: center;",
				'sort' => "<T>.CATEGORY",
			),
			array(
				'description' => "Item Group",
				'style' => "width: 1%; white-space: nowrap; text-align: center;",
				'sort' => "<T>.ITEM_GRP",
			),
			array(
				'description' => "Gold Stock (gm)",
				'style' => "width: 1%; white-space: nowrap; text-align: center;",
				'sort' => "<T>.BAL",
			),
			array(
				'description' => "Action",
				'style' => "width: 1%; white-space: nowrap; text-align: center;",
				'sort' => "",
			),
		);
		
		$sort = "";
		if($this->input->post('S') != ""){
			$decrypted_s = $this->fm->decrypt($post['S']);
			$sort = $this->input->post('SD') != "1"? $decrypted_s:$this->fm->sort_inverse($decrypted_s);
		}
		
		if($sort == ""){
			foreach($data['header_array'] as $v){
				if(isset($v['sort']) && $v['sort'] != ""){
					$sort = $v['sort'];
					break;
				}
			}
		}
		
		$data['count'] = $this->gold_model->data_count(array(
			'condition' => $condition,
		));
		
		$max_page = ceil($data['count'] / $config['per_page']);
		if($max_page <= 0) $max_page = 1;
		if($config['cur_page'] > $max_page){
			$config['cur_page'] = $max_page;
			$config['page'] = $max_page - 1;
		}
		$config['start'] = $config['page'] * $config['per_page'];

		if($this->input->post('print') == "1"){
			$limit = "999999";
		}else{
			$limit = $config['per_page'];
		}
		
		$additional_join = ""; 
        $additional_join .= "LEFT JOIN CATEGORY ON CATEGORY.CODE = <T>.CATEGORY";
        $additional_join .= " LEFT JOIN ITEM_GRP ON ITEM_GRP.CODE = <T>.ITEM_GRP";
		$data['list'] = $this->gold_model->get_data(array(
			'condition' => $condition,
			'limit' => $limit,
			'offset' => $config['start'],
			'sort' => $sort,
			'additional_select' => "CATEGORY.DESCRIPT AS CATEGORY_DESCRIPT, ITEM_GRP.DESCRIPT AS ITEM_GRP_DESCRIPT",
			'additional_join' => $additional_join,
		));

		//Company Profile
        $company = $this->company_profile_model->get_data(array(
            'condition' => "",
        ));
        $data['company'] = $company[0];

		$data['config'] = $config;
		$user = $this->fm->get_current_user();
        $data['username'] = $user->NAME;
        $data['userid'] = $user->CODE;
		
		//Access---
		$access_array = $this->fm->get_access(array(27, 28, 29));
		$data['can_create'] = isset($access_array[27]);
		$data['can_edit'] = isset($access_array[28]);
		$data['can_delete'] = isset($access_array[29]);
		//---------
		
		//Store Footprint---
		if($this->record_footprint) $this->footprint_model->record($this->router->fetch_class()."/".$this->router->fetch_method(), isset($_SERVER['QUERY_STRING'])? $_SERVER['QUERY_STRING']:"", isset($_POST)? $_POST:array());
		//------------------
		
		//Set parameter to avoid Filter Data lost---
		$this->session->set_flashdata($this->router->fetch_class().'_page_filter', $_SERVER['QUERY_STRING']);
		//------------------------------------------
	
		if($this->input->post('print') == "1"){

			$this->load->view($this->router->fetch_class()."/load_print", $data);}
		else{
			$this->load->view($this->router->fetch_class()."/load_data", $data);}
	}
}