<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Group extends MY_Controller{
	public function index(){
		$this->load->view($this->router->fetch_class()."/index");
	}
	
	public function edit($id=""){
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		$data['id'] = $id != ""? $id:0;
		
		$this->load->view($this->router->fetch_class()."/edit", $data);
	}
	
	public function load_edit(){
		$this->load->model("group_model");
		$post = $this->input->post();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		$data = array();
		
		//Access---
		$access_array = $this->fm->get_access(array(10, 11, 12));
		$data['can_create'] = isset($access_array[10]);
		$data['can_edit'] = isset($access_array[11]);
		$data['can_delete'] = isset($access_array[12]);
		//---------
		
		if($this->input->post('PKKEY') != "0"){
			$data_array = $this->group_model->get_data(array(
				'condition' => "<T>.<PK> = '".$this->fm->str_esc($post['PKKEY'], 1)."'",
				'additional_select' => "CREATE_USER.CODE AS CREATE_USER_CODE, CREATE_USER.NAME AS CREATE_USER_NAME, MODIFY_USER.CODE AS MODIFY_USER_CODE, MODIFY_USER.NAME AS MODIFY_USER_NAME",
				'' => "",
			));
			
			if(count($data_array) > 0){
				$data['data'] = $data_array[0];
			}
		}
		
		if(($data['can_create'] && $this->input->post('PKKEY') == "0") || (isset($data['data']))){
			$data['all_group'] = $this->group_model->get_data(array(
				'sort' => "WEB_GROUP.SEQN",
			));
			
			$this->load->view($this->router->fetch_class()."/load_edit", $data);
			return;
		}
		
		header("HTTP/1.1 500 Internal Server Error");
		header("Content-Type: application/json; charset=UTF-8");
		return;
	}
	
	public function update(){
		$this->load->model("group_model");
		$post = $this->input->post();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
//		print_r($post);
//		return;
		
		$return = $this->group_model->save($post);
		
		if($return['error'] == ""){
			$action = ! isset($post['PKKEY'])? "Create":"Update";
			$this->session->set_flashdata('success', $action." Successful!");
			
			if($this->input->post('DUPLICATE_GROUP') != ""){
				$access_array = $this->access_model->get_data(array(
					'condition' => "<T>.USER_GROUP = '".$post['DUPLICATE_GROUP']."'",
				));
				
				foreach($access_array as $v){
					unset($access_data);
					$access_data['MENU'] = $v->MENU;
					$access_data['USER_GROUP'] = $return['pk'];
					
					$this->access_model->sql_insert($access_data);
				}
			}
		}
		else{
			$this->session->set_flashdata('error', $return['error']);
		}
		
		redirect(base_url($this->router->fetch_class()."?".$this->session->flashdata($this->router->fetch_class().'_page_filter')));
	}
	
	public function delete(){
		$this->load->model("group_model");
		$post = $this->input->post();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		$pk = $this->group_model->sql_get_pk();
		if(isset($post[$pk]) && $this->group_model->remove($post[$pk])){
			$this->session->set_flashdata('success', "Delete Successful!");
		}
		else{
			$this->session->set_flashdata('error', "Delete Failed!");
		}
		
		redirect(base_url($this->router->fetch_class()."?".$this->session->flashdata($this->router->fetch_class().'_page_filter')));
	}
	
	public function move(){
		$this->load->model("group_model");
		$get = $this->input->get();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		$return = $this->group_model->move($get);
		
		if($return['error'] == ""){
//			$this->session->set_flashdata('success', "Move Successful!");
		}
		else{
			$this->session->set_flashdata('error', $return['error']);
		}
		
		redirect(base_url($this->router->fetch_class()."?".$this->session->flashdata($this->router->fetch_class().'_page_filter')));
	}
	
	public function check_unique(){
		$this->load->model("group_model");
		$post = $this->input->post();
		
		//To prevent loss---
		$this->fm->keep_all_page_filter();
		//------------------
		
		if($this->input->post('unique') != ""){
			$condition = "<T>.NAME = '".$this->fm->str_esc($post['unique'], 1)."'";
			if(isset($post['pk'])) $condition .= " AND <T>.<PK> != '".$post['pk']."'";
			$data_array = $this->group_model->get_data(array(
				'condition' => $condition,
			));
			
			if(count($data_array) == 0){
				echo "1";
			}
		}
	}
	
	public function load_data(){
		$this->load->model("group_model");
		$post = $this->input->post();
		
		//Config---
		$config['page'] = (int)$this->input->post('PAGE') > 0? (int)$post['PAGE']:1;
		$config['cur_page'] = $config['page'];
		$config['page'] -= 1;
		$config['per_page'] = (int)$this->input->post('PP') > 0? (int)$post['PP']:$this->per_page_array[0];
		$config['previous_btn'] = TRUE;
		$config['next_btn'] = TRUE;
		$config['first_btn'] = TRUE;
		$config['last_btn'] = TRUE;
		//---------
		
		$condition = "";
			
		//Search---
		if($this->input->post('NAME') != "" && count($post['NAME']) > 0){
			$condition = $this->fm->append($condition, $this->fm->build_condition($post['NAME'], "<T>.PKKEY"));
		}
//		if($this->input->post('NAME') != ""){
//			$condition = $this->fm->append($condition, "<T>.NAME LIKE '%".$this->fm->str_esc($post['NAME'], 1)."%'");
//		}
		//---------
		
		$data['header_array'] = array(
			array(
				'description' => "#",
				'style' => "width: 1%; white-space: nowrap; text-align: center;",
				'sort' => "",
			),
			array(
				'description' => "Name",
				'style' => "",
				'sort' => "<T>.NAME",
			),
			array(
				'description' => "Action",
				'style' => "width: 1%; white-space: nowrap; text-align: center;",
				'sort' => "",
			),
		);
		
		$sort = "";
		if($this->input->post('S') != ""){
			$decrypted_s = $this->fm->decrypt($post['S']);
			$sort = $this->input->post('SD') != "1"? $decrypted_s:$this->fm->sort_inverse($decrypted_s);
		}
		
		if($sort == ""){
			foreach($data['header_array'] as $v){
				if(isset($v['sort']) && $v['sort'] != ""){
					$sort = $v['sort'];
					break;
				}
			}
		}
		
		$data['count'] = $this->group_model->data_count(array(
			'condition' => $condition,
		));
		
		$max_page = ceil($data['count'] / $config['per_page']);
		if($max_page <= 0) $max_page = 1;
		if($config['cur_page'] > $max_page){
			$config['cur_page'] = $max_page;
			$config['page'] = $max_page - 1;
		}
		$config['start'] = $config['page'] * $config['per_page'];
		
		$data['list'] = $this->group_model->get_data(array(
			'condition' => $condition,
			'limit' => $config['per_page'],
			'offset' => $config['start'],
			'sort' => $sort,
			'' => "",
		));
		$data['config'] = $config;
		
		//Access---
		$access_array = $this->fm->get_access(array(10, 11, 12));
		$data['can_create'] = isset($access_array[10]);
		$data['can_edit'] = isset($access_array[11]);
		$data['can_delete'] = isset($access_array[12]);
		//---------
		
		//Set parameter to avoid Filter Data lost---
		$this->session->set_flashdata($this->router->fetch_class().'_page_filter', $_SERVER['QUERY_STRING']);
		//------------------------------------------
	
		$this->load->view($this->router->fetch_class()."/load_data", $data);
	}
}