<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Email_model extends MY_Model{
	function __construct(){
		parent::__construct();
		
		$this->table = "WEB_EMAIL_ERROR";
		$this->record_sql_action = FALSE;
	}
	
	function send($to_array="", $subject="", $message="", $cc_array="", $bcc_array="", $attach=array()){
		$this->load->model("email_setting_model");
		
		//Note:
		//	- 'to_array', 'cc_array', 'bcc_array' can be string or array
		//	- 'attach': file_path/file_name.ext
		
		if($to_array != ""){
			$setting = $this->email_setting_model->get_setting();
			
			if($setting != NULL && isset($setting->HOST, $setting->PORT, $setting->EMAIL)){
				$config = Array(
//					'protocol' => "smtp",
//					'smtp_host' => "ssl://smtp.googlemail.com",
//					'smtp_port' => 465,
//					'smtp_user' => "domaincomputertesting@gmail.com",
//					'smtp_pass' => "testing123456",
//					'mailtype' => "html", 
//					'charset' => "utf-8",

					'protocol' => "smtp",
					'smtp_host' => $setting->HOST,
					'smtp_port' => $setting->PORT,
					'smtp_user' => $setting->EMAIL,
					'smtp_pass' => $setting->PASSWORD,
					'mailtype' => "html", 
					'charset' => "utf-8",
				);
				$this->load->library("email", $config);
				
				$this->email->set_newline("\r\n");
				
				$from = $setting->EMAIL;
				$from_name = $setting->NAME;
				
				$from_name != ""? $this->email->from($from, $from_name):$this->email->from($from);
				$this->email->to($to_array);
				$this->email->subject($subject);
				$this->email->message($message);
				if($cc_array != "") $this->email->cc($cc_array);
				if($bcc_array != "") $this->email->bcc($bcc_array);
				if(count($attach) > 0){
					foreach($attach as $x=>$v){
						if(file_exists($v)){
							$this->email->attach($v);
						}
						else{
							unset($attach[$x]);
						}
					}
					$attach = array_values($attach);
				}
				
				$result = @$this->email->send();
				if(! $result){
					unset($error_data);
					$error_data['FROM'] = $from;
					$error_data['TO'] = "";
					$error_data['CC'] = "";
					$error_data['BCC'] = "";
					$error_data['SUBJECT'] = $subject;
					$error_data['MSG'] = $message;
					$error_data['ATTACH'] = "";
					$error_data['ERROR'] = $this->email->print_debugger();
					
					if(! is_array($to_array)){
						$error_data['TO'] = $to_array;
					}
					else{
						foreach($to_array as $v){
							if($error_data['TO'] != "") $error_data['TO'] .= ", ";
							$error_data['TO'] .= $v;
						}
					}
					
					if(! is_array($cc_array)){
						$error_data['CC'] = $cc_array;
					}
					else{
						foreach($cc_array as $v){
							if($error_data['CC'] != "") $error_data['CC'] .= ", ";
							$error_data['CC'] .= $v;
						}
					}
					
					if(! is_array($bcc_array)){
						$error_data['BCC'] = $bcc_array;
					}
					else{
						foreach($bcc_array as $v){
							if($error_data['BCC'] != "") $error_data['BCC'] .= ", ";
							$error_data['BCC'] .= $v;
						}
					}
					
					foreach($attach as $v){
						if($error_data['ATTACH'] != "") $error_data['ATTACH'] .= ", ";
						$error_data['ATTACH'] .= $v;
					}
					
					$this->sql_insert($error_data);
				}
				
				return $result;
			}
		}
	}
}