<?php $ci = get_instance();?>

<table class="visible-xs table table-bordered">
	<?php if(count($list) > 0):?>
		<?php foreach($list as $lv):?>
			<tr data-id="<?php echo $lv->CODE;?>" class="xs_tr_data" style="cursor: pointer;">
				<td style="vertical-align: middle; padding: 5px;">
					<table class="FG_table" style="margin: 0;">
						<tr>
							<th class="FG_th" style="padding: 5px;">Code:</th>
							<td class="FG_td" style="padding: 5px;">
								<?php echo $lv->CODE;?>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		<?php endforeach;?>
	<?php else:?>
		<tr>
			<td style="text-align: center; padding-top: 25px; padding-bottom: 25px;">No result.</td>
		</tr>
	<?php endif;?>
</table>

<table class="hidden-xs table table-bordered table-hover">
	<thead>
		<tr>
			<?php echo $ci->fm->generate_table_header($header_array);?>
		</tr>
	</thead>
	<tbody>
		<?php if(count($list) > 0):?>
			<?php $n = ($config['page'] * $config['per_page']) + 1;?>
			<?php foreach($list as $lv):?>
				<tr>
					<td style="text-align: center;"><?php echo $n;?></td>
					<td style="text-align: left;"><?php echo $lv->CODE;?></td>
					<td style="text-align: left;"><?php echo $lv->NAME;?></td>
					<td style="text-align: left;"><?php echo $lv->SNAME;?></td>
					<td style="text-align: left;"><?php echo $lv->E_MAIL;?></td>
					<td style="text-align: center; white-space: nowrap;">
						<div class="btn-group">
							<?php 
								$btn_array = array();
								array_push($btn_array, array(
									'href' => base_url($this->router->fetch_class()."/edit/".$lv->CODE),
									'icon' => "fa fa-fw ".($can_edit? "fa-edit":"fa-search"),
									'description' => $can_edit? "Edit":"View",
								));
								echo $ci->fm->generate_btn($btn_array);
							?>
						</div>
					</td>
				</tr>
				<?php $n++;?>
			<?php endforeach;?>
		<?php else:?>
			<tr>
				<td colspan="99">
					<center>
						No result.
					</center>
				</td>
			</tr>
		<?php endif;?>
	</tbody>
</table>

<?php echo $ci->load->view("includes/pagination", array('config' => $config, 'count' => $count));?>
<?php echo $ci->load->view("includes/per_page");?>

<script>
	$(document).ready(function(){
		<?php if($can_create):?>
			$("#div_btn_new").show("fast");
		<?php endif;?>
		
		$(".xs_tr_data").click(function(){
			var id = $(this).attr("data-id");
			window.location.assign("<?php echo base_url($this->router->fetch_class()."/edit/");?>/" + id);
		});
	});
</script>