<?php $paginations = $this->pagination_model->get_pagination($config, $count);?>

<table class="visible-xs table table-bordered">
	<tr><!-- To avoid 1st data being striped --></tr>
	<?php if(count($list) > 0):?>
		<?php foreach($list as $lv):?>
			<tr data-id="<?php echo $lv->ID;?>" class="xs_tr_data" style="cursor: pointer;">
				<td style="vertical-align: middle; padding: 5px;">
					<table class="FG_table" style="margin: 0;">
						<tr>
							<th class="FG_th" style="padding: 5px;">Date:</th>
							<td class="FG_td" style="padding: 5px;"><?php if($lv->DATE_CREATED != "") echo date("d M Y h:i a", strtotime($lv->DATE_CREATED));?></td>
						</tr>
						<tr>
							<th class="FG_th" style="padding: 5px;">Subject</th>
							<td class="FG_td" style="padding: 5px;"><?php echo $lv->SUBJECT;?></td>
						</tr>
						<tr>
							<th class="FG_th" style="padding: 5px;">Status:</th>
							<td class="FG_td" style="padding: 5px;">
								<span class="label label-<?php echo $lv->SUCCESS? "success":"danger";?>">
									<?php echo $lv->SUCCESS? "SUCCESS":"FAILED";?>
								</span>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		<?php endforeach;?>
	<?php else:?>
		<tr>
			<td style="text-align: center; padding-top: 25px; padding-bottom: 25px;">No result.</td>
		</tr>
	<?php endif;?>
</table>

<table class="hidden-xs table table-bordered table-hover">
	<thead>
		<tr>
			<th style="width: 1%; white-space: nowrap;">#</th>
			<th style="width: 1%; white-space: nowrap;">Date</th>
			<th>Subject</th>
			<th style="width: 1%; white-space: nowrap;">Status</th>
			<th style="width: 1%; white-space: nowrap; text-align: center;">Action</th>
		</tr>
	</thead>
	<tbody>
		<?php if(count($list) > 0):?>
			<?php $n = ($config['page'] * $config['per_page']) + 1;?>
			<?php foreach($list as $lv):?>
				<tr>
					<td style="white-space: nowrap;"><?php echo $n;?></td>
					<td style="white-space: nowrap;"><?php if($lv->DATE_CREATED != "") echo date("d M Y h:i a", strtotime($lv->DATE_CREATED));?></td>
					<td><?php echo $lv->SUBJECT;?></td>
					<td style="white-space: nowrap; text-align: center;">
						<span class="label label-<?php echo $lv->SUCCESS? "success":"danger";?>">
							<?php echo $lv->SUCCESS? "SUCCESS":"FAILED";?>
						</span>
					</td>
					<td style="text-align: center; white-space: nowrap;">
						<div class="btn-group">
							<a href="<?php echo base_url($this->router->fetch_class()."/edit/".$lv->ID);?>" class="btn btn-default btn-xs" style="float: none; margin: -2px;" title="View">
								<i class="fa fa-search"></i>
							</a>
						</div>
					</td>
				</tr>
				<?php $n++;?>
			<?php endforeach;?>
		<?php else:?>
			<tr>
				<td colspan="99">
					<center>
						No result.
					</center>
				</td>
			</tr>
		<?php endif;?>
	</tbody>
</table>

<?php if($paginations != ""):?>
	<ul class="pagination">
		<?php echo $paginations;?>
	</ul>
<?php endif;?>

<script>
	$(document).ready(function(){
		$(".xs_tr_data").click(function(){
			var id = $(this).attr("data-id");
			window.location.assign("<?php echo base_url($this->router->fetch_class()."/edit/");?>/" + id);
		});
	});
	
	$("#ajax_container .pagination li.c_pagination").click(function(){
		var page = $(this).attr("p");
		$("#PAGE").val(page);

		$("#filter_form").submit();
	});
</script>