<?php $ci = get_instance();?>
<!DOCTYPE html>
<html lang="en">
<head>
	<?php $this->load->view("includes/header");?>
</head>

<body>
	<?php $this->load->view("includes/menu");?>
	
	<section class="content">
		<?php $this->load->view("includes/nav");?>
		
		<div class="wraper container-fluid xs_container-fluid">
<!--			<div class="page-title"> -->
<!--				<h3 class="title">Panels</h3> -->
<!--			</div>-->
			
			<div class="row">
				<div class="col-md-offset-2 col-md-8">
					<?php $this->load->view("includes/success_msg");?>
					
					<div class="panel panel-default xs_panel" style="padding-left: 10px; padding-right: 10px;">
						<div class="panel-heading">
							<center>
								<h3 class="panel-title">
									<i class="fa fa-user fa-fw"></i>
									Profile
								</h3> 
							</center>
						</div>
						<div class="panel-body">
							<form onSubmit="return validation();" action="<?php echo base_url($this->router->fetch_class()."/update")?>" method="POST" accept-charset="utf-8" enctype="multipart/form-data">
								<!--  -->
								<input type="hidden" name="PKKEY" value="<?php echo $user->PKKEY;?>">
								<!--  -->
								
								<div class="form-group">
									<label>Username</label>
									<p class="form-control-static"><?php echo $user->CODE;?></p>
								</div>
								
								<div class="form-group">
									<label>Name</label>
									<input type="text" name="NAME" onClick="input_assist(this, 1);" value="<?php echo $ci->fm->str_esc($user->NAME, 2);?>" maxlength="100" class="form-control" required="required" autocomplete="OFF">
								</div>
								
								<div class="form-group">
									<label>New Password</label>
									<div id="div_new_password">
										<input type="password" id="new_password" name="PASSWORD" onKeyUp="check_new_password();" onKeyDown="$('#div_new_password').removeClass('has-error');" onClick="input_assist(this, 2);" class="form-control" autocomplete="OFF">
									</div>
								</div>
								
								<div id="div_confirm_password" style="display: none;" class="form-group">
									<label>Confirm Password</label>
									<div>
										<input type="password" id="confirm_password" class="form-control" onKeyDown="$(this).closest('div').removeClass('has-error');" onClick="input_assist(this, 2);" required="required" autocomplete="OFF">
									</div>
								</div>
								
								<hr>
								
								<div class="form-group">
									<label>Current Password</label>
									<input type="password" name="OLD_PASSWORD" onClick="input_assist(this, 2);" class="form-control" required="required" autocomplete="OFF">
									<span style="color: #FF9900;"><b>Note: Please enter your current password to make changes.</b></span>
								</div>
								
								<div class="form-group">
									<label></label>
									<button type="submit" class="btn btn-primary btn-xs-block btn_submit">
										<i class="fa fa-save"></i>
										Save
									</button>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<?php $this->load->view("includes/footer");?>
	</section>

	<script>
		$(document).ready(function(){
			$("#confirm_password").prop("disabled", true);
		});

		function check_new_password(){
			if($("#new_password").val() != ""){
				$("#div_confirm_password").show("fast");
				$("#confirm_password").prop("disabled", false);
			}
			else{
				$("#div_confirm_password").hide("fast");
				$("#confirm_password").prop("disabled", true);
			}
		}

		function validation(){
			if($("#new_password").val() != "" && $("#new_password").val() != $("#confirm_password").val()){
				$("#confirm_password").closest("div").addClass("has-error");
				prompt_error("Please confirm your password!", 250);
				return false;
			}

			var available_char = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
			var new_password = $("#new_password").val();
			for(var x=0; x<new_password.length; x++){
				var c = new_password.substr(x, 1).toUpperCase();
				
				if(available_char.indexOf(c) == "-1"){
					$("#div_new_password").addClass("has-error");
					prompt_error("Your password can only contains alphabets or numbers!", 250);
					return false;
				}
			}

			disable_btn(".btn_submit");
		}
	</script>
</body>
</html>
