<?php $ci = get_instance();?>
<!DOCTYPE html>
<html lang="en">
<head>
	<?php $this->load->view("includes/header");?>
</head>

<body>
	<?php $this->load->view("includes/menu");?>
	
	<section class="content">
		<?php $this->load->view("includes/nav");?>
		
		<div class="wraper container-fluid xs_container-fluid">
<!--			<div class="page-title"> -->
<!--				<h3 class="title">Panels</h3> -->
<!--			</div>-->
			
			<div class="row">
				<div class="col-md-12">
					<?php $this->load->view("includes/success_msg");?>
					
					<div class="panel panel-default xs_panel" style="padding-left: 10px; padding-right: 10px;">
						<div class="panel-heading">
							<center>
								<h3 class="panel-title">
									<i class="fa fa-line-chart fa-fw"></i>
									Stock Record Report
								</h3> 
							</center>
							
						</div>
						
						<div class="panel-body">
							<form id="form" onSubmit="return edit_validation(this);" action="" method="GET" autocomplete="off">
								<table class="FG_table" style="width: 550px; margin: 0 auto;">
									<tr>
										<th class="FG_th"><span style="color: red;">*</span> Category: </th>
										<td class="FG_td form-group" colspan="5">
											<div class="has-feedback">
												<select name="CATEGORY" id="category" onChange="change_category();" class="form-control select2" required="required">
													<option value="">--- Select a value ---</option>
													<option value="monthly_report">Monthly Report</option>
													<option value="sales_report">Sales Report (Weight Out)</option>
													<option value="purchase_report">Purchase Report (Weight In)</option>
													<option value="tradein_report">Trade In Report (Weight In)</option>
												</select>
											</div>
										</td>
									</tr>
									<tr id="date" style="display:none;">
										<th class="FG_th">
											Date:
										</th>
										<td class="FG_td" style="">
											<div class="has-feedback pull-left" style="width: 199px;">
												<?php 
													$date_from = "";
													if(isset($_GET['DATE_FROM'])){
														if(strlen($_GET['DATE_FROM']) > 0) $date_from = date("Y-m-d", strtotime($_GET['DATE_FROM']));
													}
													else{
														$date_from = date("Y-m-01");
													}
												?>
												<input type="text" name="DATE_FROM" value="<?php echo $date_from;?>" class="form-control datepicker" autocomplete="OFF">
												<span class="fa fa-calendar form-control-feedback" style="top: 10px; right: 0px;" aria-hidden="true"></span>
											</div>
											<div class="pull-left form-control-static" style="width: 50px; text-align: center;">To</div>
											<div class="has-feedback pull-left" style="width: 199px;">
												<?php 
													$date_to = "";
													if(isset($_GET['DATE_TO'])){
														if(strlen($_GET['DATE_TO']) > 0) $date_to = date("Y-m-d", strtotime($_GET['DATE_TO']));
													}
													else{
														$date_to = date("Y-m-d");
													}
												?>
												<input type="text" name="DATE_TO" value="<?php echo $date_to;?>" class="form-control datepicker" autocomplete="OFF">
												<span class="fa fa-calendar form-control-feedback" style="top: 10px; right: 0px;" aria-hidden="true"></span>
											</div>
										</td>
									</tr>
									<tr>
										<th class="FG_th">
											Font Size:
										</th>
										<td class="FG_td input-group" style="max-width: 200px;">
												<input type="text" name="FONTSIZE" value="<?php echo $this->input->get('FONTSIZE') != ""? $_GET['FONTSIZE']:10;?>" onInput="check_number_only(this);" class="form-control" autocomplete="OFF">
											<span class="input-group-addon">px</span>
										</td>
									</tr>
								</table>			
								
								<div style="text-align: center; margin-top: 10px;">
									<button type="submit" id="edit_btn_submit" class="btn btn-primary btn_submit" style="">
										<i class=""></i>
										Generate
									</button>
									<button type="button" onClick="print_document();" class="btn btn-primary btn_print" style="display: none; margin-left: 5px;">
										<i class="fa fa-print fa-fw"></i>
										Print
									</button>
									<!-- <button type="button" onClick="print_document('EXCEL');" class="btn btn-success btn_excel" style="display: none; margin-left: 5px;">
										<i class="fa fa-file-excel-o fa-fw"></i>
										Excel
									</button> -->
								</div>
								</form>
							
							<div id="ajax_container" style="margin-top: 20px;overflow-x: auto;"><!-- AJAX --></div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php $this->load->view("includes/footer");?>
	</section>
	<div id="div_print" style="display: none;"></div>
	
	<script type="text/javascript">
		$(document).ready(function(){

			$(".select2").select2();

			$("#form [name='DATE_FROM']").datepicker({
				format: "yyyy-mm-dd",
				autoclose: true,
				todayHighlight: true,
			});
			$("#form [name='DATE_TO']").datepicker({
				format: "yyyy-mm-dd",
				autoclose: true,
				todayHighlight: true,
			});

			$("#form .timepicker[name='TIME_TO']").timepicker({
             defaultTime: false,
             minuteStep: 15,
             showMeridian: false,
             snapToStep: true,
             showSeconds: true,
             icons: {
                 up: "fa fa-chevron-up",
                 down: "fa fa-chevron-down",
             },
         	}); 

			$("#form .timepicker[name='TIME_FROM']").timepicker({
             defaultTime: false,
             minuteStep: 15,
             showMeridian: false,
             snapToStep: true,
             showSeconds: true,
             icons: {
                 up: "fa fa-chevron-up",
                 down: "fa fa-chevron-down",
             },
         	}); 
          
			json_resource(function(){
				load_data();
			});

			//Sub Report------
			// change_category_report();
			$("#category").select2("val", "<?php echo $this->input->get('CATEGORY');?>");
			//----------------
			
			change_category();

		});

		//Global Variables---
		var timer_check_unique;
		var checking_unique;

		var row_n = 1;
		var timer_filter;
		//-------------------
	
		function json_resource(callback){
			$(".resource_loader").show("fast");

			var params = "";
			params += "&t[]=DEBTOR";
			params += "&c[]=<T>.CODE IS NOT NULL AND <T>.CODE != ''";
			params += "&s[]=<T>.CODE";
			
			var site = "<?php echo base_url("api/get_resource");?>";
			site += "?" + params;

			$.getJSON(encodeURI(site), function(result){
				if(result != ""){
					//DEBTOR---
					<?php $field = "DEBTOR[]";?>
					var selector = "#form [name='<?php echo $field;?>']";
					var string = "";
					// string += "<option value=''>--- Select a value ---</option>";
					$(result.DEBTOR).each(function(index, value){
						string += "<option value='" + value.CODE + "'>" + value.NAME + "</option>";
					});
					$(selector).html(string);

					var value = [];
					<?php if(is_array($this->input->get(str_replace("[]", "", $field)))):?>
						<?php foreach($this->input->get(str_replace("[]", "", $field)) as $v):?>
							value.push("<?php echo $v;?>");
						<?php endforeach;?>
					<?php endif;?>
					$(selector).select2("val", value);
					//----------
				}
			})
			.done(function(){
			})
			.fail(function(){
			})
			.always(function(){
				$(".resource_loader").hide("fast");
				if(callback != undefined) callback();
			});
		}
 
		function change_category(){
			var category_id = $("#category").val();

			clear_params(function(){
				switch(category_id){
					case "monthly_report":	
						$("#date").show("fast");
						break;
					case "sales_report":	
						$("#date").show("fast");
						break;
					case "purchase_report":	
						$("#date").show("fast");
						break;
					case "tradein_report":	
						$("#date").show("fast");
						break;
				}
			});
		}

		function clear_params(callback){
			$("#date").hide("fast");
			
			json_resource();

			if(callback != undefined) callback();
		}

		
			function load_data(callback){
			//Loader---
			$("#ajax_container").html("<?php echo $this->text_ajax_loader;?>");
			//---------
			
			var fontsize = parseFloat($("#fontSize").val());
			//var category = $("#category").val();
			
			var params = "";
			
			$("#form [name]").each(function(){
				var name = $(this).attr("name");
				var value = $(this).val();
				
				if($(this).is(":checkbox")){
					if($(this).is(":checked")) params += "&" + name + "=" + value;
				}
				else{
					if($.isArray(value)){
						$(value).each(function(x, v){
							if(v != null){
								params += "&" + name + "=" + v;
							}
						});
					}
					else{
						if(value != null){
							params += "&" + name + "=" + value;
						}
					}
				}
			});
			
			$.ajax({
				type: "POST",
				url: "<?php echo base_url($this->router->fetch_class());?>/load_data?<?php echo $_SERVER['QUERY_STRING'];?>",
				data: params,
				success: function(result, status, xhr){
					$("#ajax_container").html(result);
					enable_btn("#btn_print");
				},
				error: function(xhr,status,error){
					$("#ajax_container").html("<?php echo $this->text_ajax_fail;?>");
				},
				complete: function(xhr,status){
					enable_btn("#btn_generate");
				},
			});
		}

		function print_document(mode){
			if(mode == null) mode = "PRINT";
			
			var fontsize = parseFloat($("#fontSize").val());
			
			var params = "";


			$("#form [name]").each(function(){
			var name = $(this).attr("name");
			var value = $(this).val();
			
			if($(this).is(":checkbox")){
				if($(this).is(":checked")) params += "&" + name + "=" + value;
			}
			else{
				if($.isArray(value)){
					$(value).each(function(x, v){
						if(v != null){
							params += "&" + name + "=" + v;
						}
					});
				}
				else{
					if(value != null){
						params += "&" + name + "=" + value;
					}
				}
			}
		});
			$.ajax({
				type: "POST",
				url: "<?php echo base_url($this->router->fetch_class());?>/load_data",
				data: params,
				success: function(result, status, xhr){
					$("#div_print").html(result);

					switch(mode){
						case "EXCEL":
							export_excel({
								TARGET: "#div_print",
								FILENAME: "Stock Record",
								WIDTH: {
									A: 14,
									B: 14,
									C: 14,
									D: 14,
									E: 14,
									F: 14,
									G: 2,
									H: 14,
									I: 14,
									J: 14,
									K: 14,
									L: 2,
									M: 14,
									N: 14,
									O: 14,
									P: 14,
									Q: 2,
									R: 14,
									S: 14,
									T: 2,
									U: 14,
									V: 14,
									W: 2,
									X: 18,
									Y: 18,
									Z: 14,
								},
							});
							break;
						case "PRINT":
							browser_print("#div_print");
							break;
					}
				},
				error: function(xhr,status,error){
					prompt_error("<?php echo $this->text_ajax_fail;?>");
				},
				complete: function(xhr,status){
					dismiss_loading();
				},
			});
			
		}

		function edit_validation(form){
			if($("[name='DATE_FROM']").val() > $("[name='DATE_TO']").val())
			{
				prompt_error("Please select a valid date range!");
				return false;
			}
		}
	</script>
</body>
</html>
